<?php
error_reporting(0);
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
error_reporting(0);
include 'connect.php';

try {
    // Prepare SQL query
    pg_prepare($db_connection, 'sqlfetch', 'SELECT * FROM groceries_types ORDER BY id ASC');

    // Execute query
    $result = pg_execute($db_connection, 'sqlfetch', array());

    if (!$result) {
        throw new Exception('Query execution failed.');
    }

    $categories = array();
    while ($row = pg_fetch_assoc($result)) {
        $categories[] = $row;
    }

    echo json_encode([
        "success" => true,
        "data" => $categories
    ]);

} catch (Exception $e) {
    echo json_encode([
        "success" => false,
        "message" => "Error fetching categories",
        "error" => $e->getMessage()
    ]);
}
?>
