<?php
/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Numbers
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Twilio\Rest\Numbers\V1;

use Twilio\Values;
abstract class PortingPortInModels
{
    /**
     * @property string $phoneNumber Phone number to be ported. This must be in the E164 Format.
     * @property string $pin Some losing carriers require a PIN to authorize the port of a phone number. If the phone number is a US mobile phone number, the PIN is mandatory to process a porting request. Other carriers and number types may also require a PIN, you'll need to contact the losing carrier to determine what your phone number's PIN is.
    */
    public static function createNumbersV1PortingPortInCreatePhoneNumbers(array $payload = []): NumbersV1PortingPortInCreatePhoneNumbers
    {
        return new NumbersV1PortingPortInCreatePhoneNumbers($payload);
    }

    /**
     * @property string $street The street address, ex: 101 Spear St
     * @property string $street2 The building information, ex : 5th floor.
     * @property string $city The city name, ex: San Francisco.
     * @property string $state The state name, ex: CA or California. Note this should match the losing carrier’s information exactly. So if they spell out the entire state’s name instead of abbreviating it, please do so.
     * @property string $zip The zip code, ex: 94105.
     * @property string $country The country, ex: USA.
    */
    public static function createNumbersV1PortingAddress(array $payload = []): NumbersV1PortingAddress
    {
        return new NumbersV1PortingAddress($payload);
    }

    /**
     * @property string $customerName Customer name as it is registered with the losing carrier. This can be an individual or a business name depending on the customer type selected.
     * @property string $accountNumber The account number of the customer for the losing carrier. Only require for mobile phone numbers.
     * @property string $accountTelephoneNumber The account phone number of the customer for the losing carrier.
     * @property string $addressSid If you already have an Address SID that represents the address needed for the LOA, you can provide an Address SID instead of providing the address object in the request body. This will copy the address into the port in request. If changes are made to the Address SID after port in request creation, those changes will not be reflected in the port in request.
     * @property NumbersV1PortingAddress $address
     * @property string $authorizedRepresentative The first and last name of the person listed with the losing carrier who is authorized to make changes on the account.
     * @property string $authorizedRepresentativeEmail Email address of the person (owner of the number) who will sign the letter of authorization for the port in request. This email address should belong to the person named in as the authorized representative.
     * @property string $customerType The type of customer account in the losing carrier. This should either be: 'Individual' or 'Business'.
     * @property string $authorizedRepresentativeKatakana
     * @property string $subMunicipality
     * @property string $building
     * @property string $katakanaName
    */
    public static function createNumbersV1PortingLosingCarrierInformation(array $payload = []): NumbersV1PortingLosingCarrierInformation
    {
        return new NumbersV1PortingLosingCarrierInformation($payload);
    }

    /**
     * @property string $accountSid Account Sid or subaccount where the phone number(s) will be Ported
     * @property string[] $documents List of document SIDs for all phone numbers included in the port in request. At least one document SID referring to a document of the type Utility Bill is required.
     * @property NumbersV1PortingPortInCreatePhoneNumbers[] $phoneNumbers List of phone numbers to be ported. Maximum of 1,000 phone numbers per request.
     * @property NumbersV1PortingLosingCarrierInformation $losingCarrierInformation
     * @property string[]|null $notificationEmails Additional emails to send a copy of the signed LOA to.
     * @property \DateTime|null $targetPortInDate Target date to port the number. We cannot guarantee that this date will be honored by the other carriers, please work with Ops to get a confirmation of the firm order commitment (FOC) date. Expected format is ISO Local Date, example: ‘2011-12-03`. This date must be at least 7 days in the future for US ports and 10 days in the future for Japanese ports. We can't guarantee the exact date and time, as this depends on the losing carrier
     * @property string|null $targetPortInTimeRangeStart The earliest time that the port should occur on the target port in date. Expected format is ISO Offset Time, example: ‘10:15:00-08:00'. We can't guarantee the exact date and time, as this depends on the losing carrier
     * @property string|null $targetPortInTimeRangeEnd The latest time that the port should occur on the target port in date. Expected format is ISO Offset Time, example: ‘10:15:00-08:00'. We can't guarantee the exact date and time, as this depends on the losing carrier
     * @property string|null $bundleSid The bundle sid is an optional identifier to reference a group of regulatory documents for a port request.
     * @property string|null $portabilityAdvanceCarrier A field only required for Japan port in requests. It is a unique identifier for the donor carrier service the line is being ported from.
     * @property string|null $autoCancelApprovalNumbers Japan specific field, indicates the number of phone numbers to automatically approve for cancellation.
    */
    public static function createNumbersV1PortingPortInCreate(array $payload = []): NumbersV1PortingPortInCreate
    {
        return new NumbersV1PortingPortInCreate($payload);
    }

}

class NumbersV1PortingPortInCreatePhoneNumbers implements \JsonSerializable
{
    /**
     * @property string $phoneNumber Phone number to be ported. This must be in the E164 Format.
     * @property string $pin Some losing carriers require a PIN to authorize the port of a phone number. If the phone number is a US mobile phone number, the PIN is mandatory to process a porting request. Other carriers and number types may also require a PIN, you'll need to contact the losing carrier to determine what your phone number's PIN is.
    */
        protected $phoneNumber;
        protected $pin;
    public function __construct(array $payload = []) {
        $this->phoneNumber = Values::array_get($payload, 'phone_number');
        $this->pin = Values::array_get($payload, 'pin');
    }

    public function toArray(): array
    {
        return $this->jsonSerialize();
    }

    public function jsonSerialize(): array
    {
        $jsonString = [
            'phone_number' => $this->phoneNumber
        ];
        if (isset($this->pin)) {
            $jsonString['pin'] = $this->pin;
        }
        return $jsonString;
    }
}

class NumbersV1PortingAddress implements \JsonSerializable
{
    /**
     * @property string $street The street address, ex: 101 Spear St
     * @property string $street2 The building information, ex : 5th floor.
     * @property string $city The city name, ex: San Francisco.
     * @property string $state The state name, ex: CA or California. Note this should match the losing carrier’s information exactly. So if they spell out the entire state’s name instead of abbreviating it, please do so.
     * @property string $zip The zip code, ex: 94105.
     * @property string $country The country, ex: USA.
    */
        protected $street;
        protected $street2;
        protected $city;
        protected $state;
        protected $zip;
        protected $country;
    public function __construct(array $payload = []) {
        $this->street = Values::array_get($payload, 'street');
        $this->street2 = Values::array_get($payload, 'street_2');
        $this->city = Values::array_get($payload, 'city');
        $this->state = Values::array_get($payload, 'state');
        $this->zip = Values::array_get($payload, 'zip');
        $this->country = Values::array_get($payload, 'country');
    }

    public function toArray(): array
    {
        return $this->jsonSerialize();
    }

    public function jsonSerialize(): array
    {
        $jsonString = [
            'street' => $this->street,
            'city' => $this->city,
            'state' => $this->state,
            'zip' => $this->zip,
            'country' => $this->country
        ];
        if (isset($this->street2)) {
            $jsonString['street_2'] = $this->street2;
        }
        return $jsonString;
    }
}

class NumbersV1PortingLosingCarrierInformation implements \JsonSerializable
{
    /**
     * @property string $customerName Customer name as it is registered with the losing carrier. This can be an individual or a business name depending on the customer type selected.
     * @property string $accountNumber The account number of the customer for the losing carrier. Only require for mobile phone numbers.
     * @property string $accountTelephoneNumber The account phone number of the customer for the losing carrier.
     * @property string $addressSid If you already have an Address SID that represents the address needed for the LOA, you can provide an Address SID instead of providing the address object in the request body. This will copy the address into the port in request. If changes are made to the Address SID after port in request creation, those changes will not be reflected in the port in request.
     * @property NumbersV1PortingAddress $address
     * @property string $authorizedRepresentative The first and last name of the person listed with the losing carrier who is authorized to make changes on the account.
     * @property string $authorizedRepresentativeEmail Email address of the person (owner of the number) who will sign the letter of authorization for the port in request. This email address should belong to the person named in as the authorized representative.
     * @property string $customerType The type of customer account in the losing carrier. This should either be: 'Individual' or 'Business'.
     * @property string $authorizedRepresentativeKatakana
     * @property string $subMunicipality
     * @property string $building
     * @property string $katakanaName
    */
        protected $customerName;
        protected $accountNumber;
        protected $accountTelephoneNumber;
        protected $addressSid;
        protected $address;
        protected $authorizedRepresentative;
        protected $authorizedRepresentativeEmail;
        protected $customerType;
        protected $authorizedRepresentativeKatakana;
        protected $subMunicipality;
        protected $building;
        protected $katakanaName;
    public function __construct(array $payload = []) {
        $this->customerName = Values::array_get($payload, 'customer_name');
        $this->accountNumber = Values::array_get($payload, 'account_number');
        $this->accountTelephoneNumber = Values::array_get($payload, 'account_telephone_number');
        $this->addressSid = Values::array_get($payload, 'address_sid');
        $this->address = Values::array_get($payload, 'address');
        $this->authorizedRepresentative = Values::array_get($payload, 'authorized_representative');
        $this->authorizedRepresentativeEmail = Values::array_get($payload, 'authorized_representative_email');
        $this->customerType = Values::array_get($payload, 'customer_type');
        $this->authorizedRepresentativeKatakana = Values::array_get($payload, 'authorized_representative_katakana');
        $this->subMunicipality = Values::array_get($payload, 'sub_municipality');
        $this->building = Values::array_get($payload, 'building');
        $this->katakanaName = Values::array_get($payload, 'katakana_name');
    }

    public function toArray(): array
    {
        return $this->jsonSerialize();
    }

    public function jsonSerialize(): array
    {
        $jsonString = [
            'customer_name' => $this->customerName,
            'authorized_representative' => $this->authorizedRepresentative,
            'authorized_representative_email' => $this->authorizedRepresentativeEmail
        ];
        if (isset($this->accountNumber)) {
            $jsonString['account_number'] = $this->accountNumber;
        }
        if (isset($this->accountTelephoneNumber)) {
            $jsonString['account_telephone_number'] = $this->accountTelephoneNumber;
        }
        if (isset($this->addressSid)) {
            $jsonString['address_sid'] = $this->addressSid;
        }
        if (isset($this->address)) {
            $jsonString['address'] = $this->address;
        }
        if (isset($this->customerType)) {
            $jsonString['customer_type'] = $this->customerType;
        }
        if (isset($this->authorizedRepresentativeKatakana)) {
            $jsonString['authorized_representative_katakana'] = $this->authorizedRepresentativeKatakana;
        }
        if (isset($this->subMunicipality)) {
            $jsonString['sub_municipality'] = $this->subMunicipality;
        }
        if (isset($this->building)) {
            $jsonString['building'] = $this->building;
        }
        if (isset($this->katakanaName)) {
            $jsonString['katakana_name'] = $this->katakanaName;
        }
        return $jsonString;
    }
}

class NumbersV1PortingPortInCreate implements \JsonSerializable
{
    /**
     * @property string $accountSid Account Sid or subaccount where the phone number(s) will be Ported
     * @property string[] $documents List of document SIDs for all phone numbers included in the port in request. At least one document SID referring to a document of the type Utility Bill is required.
     * @property NumbersV1PortingPortInCreatePhoneNumbers[] $phoneNumbers List of phone numbers to be ported. Maximum of 1,000 phone numbers per request.
     * @property NumbersV1PortingLosingCarrierInformation $losingCarrierInformation
     * @property string[]|null $notificationEmails Additional emails to send a copy of the signed LOA to.
     * @property \DateTime|null $targetPortInDate Target date to port the number. We cannot guarantee that this date will be honored by the other carriers, please work with Ops to get a confirmation of the firm order commitment (FOC) date. Expected format is ISO Local Date, example: ‘2011-12-03`. This date must be at least 7 days in the future for US ports and 10 days in the future for Japanese ports. We can't guarantee the exact date and time, as this depends on the losing carrier
     * @property string|null $targetPortInTimeRangeStart The earliest time that the port should occur on the target port in date. Expected format is ISO Offset Time, example: ‘10:15:00-08:00'. We can't guarantee the exact date and time, as this depends on the losing carrier
     * @property string|null $targetPortInTimeRangeEnd The latest time that the port should occur on the target port in date. Expected format is ISO Offset Time, example: ‘10:15:00-08:00'. We can't guarantee the exact date and time, as this depends on the losing carrier
     * @property string|null $bundleSid The bundle sid is an optional identifier to reference a group of regulatory documents for a port request.
     * @property string|null $portabilityAdvanceCarrier A field only required for Japan port in requests. It is a unique identifier for the donor carrier service the line is being ported from.
     * @property string|null $autoCancelApprovalNumbers Japan specific field, indicates the number of phone numbers to automatically approve for cancellation.
    */
        protected $accountSid;
        protected $documents;
        protected $phoneNumbers;
        protected $losingCarrierInformation;
        protected $notificationEmails;
        protected $targetPortInDate;
        protected $targetPortInTimeRangeStart;
        protected $targetPortInTimeRangeEnd;
        protected $bundleSid;
        protected $portabilityAdvanceCarrier;
        protected $autoCancelApprovalNumbers;
    public function __construct(array $payload = []) {
        $this->accountSid = Values::array_get($payload, 'account_sid');
        $this->documents = Values::array_get($payload, 'documents');
        $this->phoneNumbers = Values::array_get($payload, 'phone_numbers');
        $this->losingCarrierInformation = Values::array_get($payload, 'losing_carrier_information');
        $this->notificationEmails = Values::array_get($payload, 'notification_emails');
        $this->targetPortInDate = Values::array_get($payload, 'target_port_in_date');
        $this->targetPortInTimeRangeStart = Values::array_get($payload, 'target_port_in_time_range_start');
        $this->targetPortInTimeRangeEnd = Values::array_get($payload, 'target_port_in_time_range_end');
        $this->bundleSid = Values::array_get($payload, 'bundle_sid');
        $this->portabilityAdvanceCarrier = Values::array_get($payload, 'portability_advance_carrier');
        $this->autoCancelApprovalNumbers = Values::array_get($payload, 'auto_cancel_approval_numbers');
    }

    public function toArray(): array
    {
        return $this->jsonSerialize();
    }

    public function jsonSerialize(): array
    {
        $jsonString = [
            'account_sid' => $this->accountSid,
            'documents' => $this->documents,
            'losing_carrier_information' => $this->losingCarrierInformation
        ];
        if (isset($this->phoneNumbers)) {
            $jsonString['phone_numbers'] = $this->phoneNumbers;
        }
        if (isset($this->notificationEmails)) {
            $jsonString['notification_emails'] = $this->notificationEmails;
        }
        if (isset($this->targetPortInDate)) {
            $jsonString['target_port_in_date'] = $this->targetPortInDate;
        }
        if (isset($this->targetPortInTimeRangeStart)) {
            $jsonString['target_port_in_time_range_start'] = $this->targetPortInTimeRangeStart;
        }
        if (isset($this->targetPortInTimeRangeEnd)) {
            $jsonString['target_port_in_time_range_end'] = $this->targetPortInTimeRangeEnd;
        }
        if (isset($this->bundleSid)) {
            $jsonString['bundle_sid'] = $this->bundleSid;
        }
        if (isset($this->portabilityAdvanceCarrier)) {
            $jsonString['portability_advance_carrier'] = $this->portabilityAdvanceCarrier;
        }
        if (isset($this->autoCancelApprovalNumbers)) {
            $jsonString['auto_cancel_approval_numbers'] = $this->autoCancelApprovalNumbers;
        }
        return $jsonString;
    }
}

